/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility.POSPrinter.Star;

import com.starmicronics.utility.POSPrinter.MapModeConversion;
import com.starmicronics.utility.POSPrinter.PrinterFont;
import com.starmicronics.utility.POSPrinter.Star.CommandStar;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import jpos.JposException;
import jpos.config.JposEntry;

public class CommandStarThermal
extends CommandStar {
    private boolean m_capRecFullCut = false;
    private boolean m_capRecPartialCut = false;
    private byte m_multipleHeightCommand = 0;
    private byte m_multipleWidthCommand = 0;
    private MapModeConversion m_mapMode;

    public CommandStarThermal(PrinterFont printerFont, MapModeConversion mapModeConversion, JposEntry jposEntry) {
        super(printerFont, jposEntry);
        this.m_mapMode = mapModeConversion;
        this.m_capRecPartialCut = (Boolean)jposEntry.getPropertyValue("partialCut");
        this.m_capRecFullCut = (Boolean)jposEntry.getPropertyValue("fullCut");
    }

    public List initializeCommand() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(new byte[]{27, 29, 116, this.m_printerFont.getCharacterSetByteCommand()});
        if (this.m_printerFont.getCapFontB()) {
            arrayList.add(new byte[]{27, 30, 70, this.m_printerFont.getFontSelect()});
        }
        arrayList.add(new byte[]{27, 32, this.m_printerFont.getRightSideCharacterSpacing()});
        if (24 == this.m_printerFont.getDotLineSpacing()) {
            arrayList.add(new byte[]{27, 122, 48});
        } else {
            arrayList.add(new byte[]{27, 122, 49});
        }
        arrayList.add(new byte[]{27, 70});
        arrayList.add(new byte[]{27, 45, 48});
        arrayList.add(new byte[]{27, 53});
        arrayList.add(new byte[]{27, 87, 48});
        arrayList.add(new byte[]{27, 104, 48});
        arrayList.add(new byte[]{27, 29, 97, 48});
        return arrayList;
    }

    public List barCodeCommand(String string, int n, int n2, int n3, int n4, int n5) throws JposException {
        int n6;
        int n7;
        int n8;
        byte by;
        int n9;
        int n10;
        byte[] byArray;
        int n11;
        int n12 = 0;
        int n13 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = string.getBytes();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if (-11 == n5) {
            n11 = 49;
        } else if (-13 == n5) {
            n11 = 50;
        } else {
            throw new JposException(106, "This request failed because the specified text placement is not supported.");
        }
        if (1 > n2 || 255 < n2) {
            throw new JposException(106, "This request failed because the specified height is not supported.");
        }
        if (n3 < 1 || n3 > this.m_printerFont.getLineWidthDot()) {
            throw new JposException(106, "This request failed because the specified width is not supported.");
        }
        if (0 > this.m_printerFont.getLineWidthDot() - n4 - n3) {
            throw new JposException(106, "This request failed because the specified alignment is not supported.");
        }
        if (123 == n || 110 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106);
            }
            byArray = null;
            n10 = 0;
            n12 = 54;
            n13 = 49;
            for (n9 = 0; n9 < 2; ++n9) {
                by = 0;
                for (n8 = 0; n8 < byArray3.length; ++n8) {
                    byte by2 = byArray3[n8];
                    if (by == 0) {
                        if (by2 == 123) {
                            by = 1;
                            continue;
                        }
                        if (by2 < 0 || by2 > 127) {
                            throw new JposException(106);
                        }
                        if (by2 >= 0 && by2 <= 31) {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = (byte)(64 + by2);
                            }
                            ++n10;
                            continue;
                        }
                        if (by2 == 37) {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 48;
                            }
                            ++n10;
                            continue;
                        }
                        if (by2 == 127) {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 53;
                            }
                            ++n10;
                            continue;
                        }
                        if (null != byArray) {
                            byArray[n10] = by2;
                        }
                        ++n10;
                        continue;
                    }
                    switch (by2) {
                        case 83: {
                            break;
                        }
                        case 65: {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 54;
                            }
                            ++n10;
                            break;
                        }
                        case 66: {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 55;
                            }
                            ++n10;
                            break;
                        }
                        case 67: {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 56;
                            }
                            ++n10;
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = by2;
                            }
                            ++n10;
                            break;
                        }
                        case 123: {
                            if (null != byArray) {
                                byArray[n10] = 123;
                            }
                            ++n10;
                            break;
                        }
                        default: {
                            throw new JposException(106);
                        }
                    }
                    by = 0;
                }
                if (null != byArray) continue;
                byArray = new byte[n10];
                n10 = 0;
            }
            byArray3 = byArray;
        } else if (101 == n) {
            if (byArray3.length != 11 && byArray3.length != 12) {
                throw new JposException(106, "This request failed because UPC-A barcodes require 11 or 12 data digits to be specified.");
            }
            n12 = 49;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) continue;
                throw new JposException(106, "This request failed because UPC-A barcodes require all data digits to be between '0' and '9'.");
            }
            if (n3 < 285) {
                n3 = 190;
                n13 = 49;
            } else if (n3 < 380) {
                n3 = 285;
                n13 = 50;
            } else {
                n3 = 380;
                n13 = 51;
            }
        } else if (102 == n) {
            if (byArray3.length != 11 && byArray3.length != 12) {
                throw new JposException(106, "This request failed because UPC-E barcodes require 11 or 12 data digits to be specified.");
            }
            n12 = 48;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) continue;
                throw new JposException(106, "This request failed because UPC-E barcodes require all data digits to be between '0' and '9'.");
            }
            if (n3 < 153) {
                n3 = 102;
                n13 = 49;
            } else if (n3 < 204) {
                n3 = 153;
                n13 = 50;
            } else {
                n3 = 204;
                n13 = 51;
            }
        } else if (103 == n) {
            if (byArray3.length != 7 && byArray3.length != 8) {
                throw new JposException(106, "This request failed because JAN8 barcodes require 7 or 8 data digits to be specified.");
            }
            n12 = 50;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) continue;
                throw new JposException(106, "This request failed because JAN8 barcodes require all data digits to be between '0' and '9'.");
            }
            if (n3 < 201) {
                n3 = 134;
                n13 = 49;
            } else if (n3 < 268) {
                n3 = 201;
                n13 = 50;
            } else {
                n3 = 268;
                n13 = 51;
            }
        } else if (104 == n) {
            if (byArray3.length != 12 && byArray3.length != 13) {
                throw new JposException(106, "This request failed because JAN13 barcodes require 12 or 13 data digits to be specified.");
            }
            n12 = 51;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) continue;
                throw new JposException(106, "This request failed because JAN13 barcodes require all data digits to be between '0' and '9'.");
            }
            if (n3 < 285) {
                n3 = 190;
                n13 = 49;
            } else if (n3 < 380) {
                n3 = 285;
                n13 = 50;
            } else {
                n3 = 380;
                n13 = 51;
            }
        } else if (106 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106, "This request failed because ITF barcodes require between 1 and 255 data digits to be specified.");
            }
            n12 = 53;
            n7 = 4;
            n6 = 0;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] < 48 || byArray3[n8] > 57) {
                    throw new JposException(106, "This request failed because ITF barcodes require all data digits to be between '0' and '9'.");
                }
                n7 += 3;
                n6 += 2;
            }
            if (byArray3.length % 2 != 0) {
                n7 += 3;
                n6 += 2;
            }
            if (n3 < (n7 += 2) * 2 + ++n6 * 5) {
                n3 = n7 * 2 + n6 * 4;
                n13 = 52;
            } else if (n3 < n7 * 2 + n6 * 6) {
                n3 = n7 * 2 + n6 * 5;
                n13 = 49;
            } else if (n3 < n7 * 3 + n6 * 9) {
                n3 = n7 * 2 + n6 * 6;
                n13 = 55;
            } else if (n3 < n7 * 4 + n6 * 8) {
                n3 = n7 * 3 + n6 * 9;
                n13 = 56;
            } else if (n3 < n7 * 4 + n6 * 10) {
                n3 = n7 * 4 + n6 * 8;
                n13 = 53;
            } else if (n3 < n7 * 4 + n6 * 12) {
                n3 = n7 * 4 + n6 * 10;
                n13 = 50;
            } else if (n3 < n7 * 6 + n6 * 12) {
                n3 = n7 * 4 + n6 * 12;
                n13 = 57;
            } else if (n3 < n7 * 6 + n6 * 15) {
                n3 = n7 * 6 + n6 * 12;
                n13 = 54;
            } else {
                n3 = n7 * 6 + n6 * 15;
                n13 = 51;
            }
        } else if (107 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106, "This request failed because CodeBar-A barcodes require between 1 and 255 data digits to be specified.");
            }
            n12 = 56;
            n7 = 0;
            n6 = 0;
            block32: for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) {
                    n7 += 6;
                    n6 += 2;
                    continue;
                }
                if (byArray3[n8] >= 65 && byArray3[n8] <= 68) {
                    n7 += 5;
                    n6 += 3;
                    continue;
                }
                if (byArray3[n8] >= 97 && byArray3[n8] <= 100) {
                    n7 += 5;
                    n6 += 3;
                    continue;
                }
                switch (byArray3[n8]) {
                    case 36: {
                        n7 += 6;
                        n6 += 2;
                        continue block32;
                    }
                    case 43: {
                        n7 += 5;
                        n6 += 3;
                        continue block32;
                    }
                    case 45: {
                        n7 += 6;
                        n6 += 2;
                        continue block32;
                    }
                    case 46: {
                        n7 += 5;
                        n6 += 3;
                        continue block32;
                    }
                    case 47: {
                        n7 += 5;
                        n6 += 3;
                        continue block32;
                    }
                    case 58: {
                        n7 += 5;
                        n6 += 3;
                        continue block32;
                    }
                    default: {
                        throw new JposException(106, "This request failed because CodeBar-A barcodes do not support 1 or more of the specified data digits.");
                    }
                }
            }
            if (n3 < --n7 * 2 + n6 * 5) {
                n3 = n7 * 2 + n6 * 4;
                n13 = 55;
            } else if (n3 < n7 * 2 + n6 * 6) {
                n3 = n7 * 2 + n6 * 5;
                n13 = 52;
            } else if (n3 < n7 * 3 + n6 * 6) {
                n3 = n7 * 2 + n6 * 6;
                n13 = 49;
            } else if (n3 < n7 * 3 + n6 * 8) {
                n3 = n7 * 3 + n6 * 6;
                n13 = 56;
            } else if (n3 < n7 * 3 + n6 * 9) {
                n3 = n7 * 3 + n6 * 8;
                n13 = 53;
            } else if (n3 < n7 * 4 + n6 * 8) {
                n3 = n7 * 3 + n6 * 9;
                n13 = 50;
            } else if (n3 < n7 * 4 + n6 * 10) {
                n3 = n7 * 4 + n6 * 8;
                n13 = 57;
            } else if (n3 < n7 * 4 + n6 * 12) {
                n3 = n7 * 4 + n6 * 10;
                n13 = 54;
            } else {
                n3 = n7 * 4 + n6 * 12;
                n13 = 51;
            }
        } else if (108 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106, "This request failed because Code39 barcodes require between 1 and 255 data digits to be specified.");
            }
            n12 = 52;
            n7 = 7;
            n6 = 3;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (!(byArray3[n8] >= 48 && byArray3[n8] <= 57 || byArray3[n8] >= 65 && byArray3[n8] <= 90)) {
                    switch (byArray3[n8]) {
                        case 32: {
                            break;
                        }
                        case 36: {
                            break;
                        }
                        case 37: {
                            break;
                        }
                        case 43: {
                            break;
                        }
                        case 45: {
                            break;
                        }
                        case 46: {
                            break;
                        }
                        case 47: {
                            break;
                        }
                        default: {
                            throw new JposException(106, "This request failed because Code39 barcodes do not support 1 or more of the specified data digits.");
                        }
                    }
                }
                n7 += 7;
                n6 += 3;
            }
            if (n3 < (n7 += 6) * 2 + (n6 += 3) * 5) {
                n3 = n7 * 2 + n6 * 4;
                n13 = 55;
            } else if (n3 < n7 * 2 + n6 * 6) {
                n3 = n7 * 2 + n6 * 5;
                n13 = 52;
            } else if (n3 < n7 * 3 + n6 * 6) {
                n3 = n7 * 2 + n6 * 6;
                n13 = 49;
            } else if (n3 < n7 * 3 + n6 * 8) {
                n3 = n7 * 3 + n6 * 6;
                n13 = 56;
            } else if (n3 < n7 * 3 + n6 * 9) {
                n3 = n7 * 3 + n6 * 8;
                n13 = 53;
            } else if (n3 < n7 * 4 + n6 * 8) {
                n3 = n7 * 3 + n6 * 9;
                n13 = 50;
            } else if (n3 < n7 * 4 + n6 * 10) {
                n3 = n7 * 4 + n6 * 8;
                n13 = 57;
            } else if (n3 < n7 * 4 + n6 * 12) {
                n3 = n7 * 4 + n6 * 10;
                n13 = 54;
            } else {
                n3 = n7 * 4 + n6 * 12;
                n13 = 51;
            }
        } else if (109 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106, "This request failed because Code93 barcodes require between 1 and 255 data digits to be specified.");
            }
            n12 = 55;
            byArray = null;
            n10 = 0;
            n7 = 9;
            for (n9 = 0; n9 < 2; ++n9) {
                for (n8 = 0; n8 < byArray3.length; ++n8) {
                    by = byArray3[n8];
                    if (by < 0 || by > 127) {
                        throw new JposException(106);
                    }
                    if (n9 == 0) {
                        n7 += 9;
                    }
                    if (!(by == 32 || by >= 36 && by <= 37 || by == 43 || by >= 45 && by <= 47 || by >= 48 && by <= 57 || by >= 65 && by <= 90 || n9 != 0)) {
                        n7 += 9;
                    }
                    if (by >= 0 && by <= 31) {
                        if (null != byArray) {
                            byArray[n10] = 37;
                        }
                        ++n10;
                        if (null != byArray) {
                            byArray[n10] = 64;
                        }
                        ++n10;
                        if (null != byArray) {
                            byArray[n10] = by;
                        }
                        ++n10;
                        continue;
                    }
                    if (by == 37) {
                        if (null != byArray) {
                            byArray[n10] = 37;
                        }
                        ++n10;
                        if (null != byArray) {
                            byArray[n10] = 48;
                        }
                        ++n10;
                        continue;
                    }
                    if (by == 127) {
                        if (null != byArray) {
                            byArray[n10] = 37;
                        }
                        ++n10;
                        if (null != byArray) {
                            byArray[n10] = 53;
                        }
                        ++n10;
                        continue;
                    }
                    if (null != byArray) {
                        byArray[n10] = by;
                    }
                    ++n10;
                }
                if (null != byArray) continue;
                byArray = new byte[n10];
                n10 = 0;
            }
            n7 += 9;
            n7 += 9;
            byArray3 = byArray;
            if (n3 < (n7 += 10) * 3) {
                n3 = n7 * 2;
                n13 = 49;
            } else if (n3 < n7 * 4) {
                n3 = n7 * 3;
                n13 = 50;
            } else {
                n3 = n7 * 4;
                n13 = 51;
            }
        } else {
            throw new JposException(106, "This request failed because the specified symbology is not supported.");
        }
        if (1 == this.getRotateSpecial()) {
            arrayList.add(new byte[]{18});
        } else {
            arrayList.add(new byte[]{15});
        }
        this.addArrayListElementsLast(this.initializeCommand(), arrayList);
        if (0 <= n4) {
            arrayList.add(new byte[]{27, 29, 65, (byte)(n4 % 256), (byte)(n4 / 256)});
        } else if (n4 == -1) {
            arrayList.add(new byte[]{27, 29, 97, 0});
        } else if (n4 == -2) {
            arrayList.add(new byte[]{27, 29, 97, 1});
        } else if (n4 == -3) {
            arrayList.add(new byte[]{27, 29, 97, 2});
        }
        byArray2 = new byte[6 + byArray3.length + 1];
        byArray2[0] = 27;
        byArray2[1] = 98;
        byArray2[2] = n12;
        byArray2[3] = n11;
        byArray2[4] = n13;
        byArray2[5] = (byte)n2;
        for (n8 = 0; n8 < byArray3.length; ++n8) {
            byArray2[6 + n8] = byArray3[n8];
        }
        byArray2[6 + n8] = 30;
        arrayList.add(byArray2);
        arrayList.add(new byte[]{27, 29, 97, 0});
        arrayList.add(new byte[]{27, 29, 65, 0, 0});
        return arrayList;
    }

    public byte[] paperCutCommand(int n, boolean bl, boolean bl2) throws JposException {
        byte[] byArray = new byte[]{27, 100, 0};
        if (100 < n) {
            byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 2) : 0;
        } else {
            if (0 > n) {
                throw new JposException(106, "This request is illegal");
            }
            if (100 == n) {
                byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 2) : 0;
            } else if (0 == n) {
                if (bl) {
                    if (!this.m_capRecPartialCut && !this.m_capRecFullCut) {
                        byArray[2] = 116;
                    } else {
                        byArray[1] = 97;
                        byArray[2] = 1 > this.m_printerFont.getRecLinesToPaperCut() ? 1 : (127 < this.m_printerFont.getRecLinesToPaperCut() ? 127 : (byte)this.m_printerFont.getRecLinesToPaperCut());
                    }
                }
            } else {
                byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 3) : 1;
            }
        }
        return byArray;
    }

    protected void multipleHeightSetting(int n, boolean bl) throws JposException {
        if (1 > n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and print with the normal height.");
            }
            this.m_multipleHeightCommand = 0;
        } else if (6 < n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and print with the height scaled 6 times the normal size.");
            }
            this.m_multipleHeightCommand = (byte)5;
        } else {
            this.m_multipleHeightCommand = (byte)(n - 1);
        }
    }

    protected void multipleWidthSetting(int n, boolean bl) throws JposException {
        if (1 > n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to normal.");
            }
            this.m_multipleWidthCommand = 0;
        } else if (6 < n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to 6 width.");
            }
            this.m_multipleWidthCommand = (byte)5;
        } else {
            this.m_multipleWidthCommand = (byte)(n - 1);
        }
    }

    protected byte[] multipleHeightAndWidthCommand() throws JposException {
        return new byte[]{27, 87, this.m_multipleWidthCommand, 27, 104, this.m_multipleHeightCommand};
    }

    protected byte[] feedUnitsCommand(int n, boolean bl) throws JposException {
        int n2 = this.m_mapMode.mapModeToDotHeight(n);
        n2 = 0 != n2 % 2 ? n2 / 2 + 1 : (n2 /= 2);
        if (1 > n2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 1 dot.");
            }
            n2 = 1;
        } else if (255 < n2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 255 dots.");
            }
            n2 = 255;
        }
        return new byte[]{27, 74, (byte)n2};
    }

    protected byte[] feedReverseCommand(int n, boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106, "This request failed because this request is not supported this print station.");
        }
        return null;
    }

    public List bitmapCommand(Image image, int n, int n2, int n3) throws JposException {
        byte[] byArray;
        int n4 = 0;
        BufferedImage bufferedImage = null;
        List list = null;
        list = this.initializeCommand();
        this.addArrayListElementsFirst(this.headerCommand(), list);
        try {
            if (n != -11) {
                image = new ImageIcon(image.getScaledInstance(n, -1, 1)).getImage();
            }
            n = image.getWidth(null);
            n4 = image.getHeight(null);
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        if (n <= 0) {
            throw new JposException(106, "This request failed because the bitmap width is 0.");
        }
        if (n > this.m_printerFont.getLineWidthDot()) {
            throw new JposException(114, 206);
        }
        if (0 > this.m_printerFont.getLineWidthDot() - n2 - n) {
            throw new JposException(106, "This request failed because the aligment parameter is not valid.");
        }
        if (n2 == -1) {
            n2 = 0;
        } else if (n2 == -2) {
            n2 = (this.m_printerFont.getLineWidthDot() - n) / 2;
        } else if (n2 == -3) {
            n2 = this.m_printerFont.getLineWidthDot() - n;
        }
        if (n4 <= 0) {
            throw new JposException(106, "This request failed because the bitmap height is 0.");
        }
        try {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        int n5 = 0;
        int n6 = 0;
        try {
            n5 = this.m_printerFont.getLineWidthDot() - n2 - n - 1 > 0 ? (n4 % 24 != 0 ? 1 + (5 + (4 + n * 3) + 5 + 7 + 3) * (n4 / 24 + 1) : 1 + (5 + (4 + n * 3) + 5 + 7 + 3) * (n4 / 24)) : (n4 % 24 != 0 ? 1 + (5 + (4 + n * 3) + 7 + 3) * (n4 / 24 + 1) : 1 + (5 + (4 + n * 3) + 7 + 3) * (n4 / 24));
            byArray = new byte[n5];
            byArray[n6++] = 1 == n3 ? 18 : 15;
            for (int i = 0; i < n4; i += 24) {
                int n7;
                byArray[n6++] = 27;
                byArray[n6++] = 29;
                byArray[n6++] = 65;
                byArray[n6++] = (byte)(n2 % 256);
                byArray[n6++] = (byte)(n2 / 256);
                byArray[n6++] = 27;
                byArray[n6++] = 88;
                byArray[n6++] = (byte)(n % 256);
                byArray[n6++] = (byte)(n / 256);
                if (1 == n3) {
                    n7 = 0;
                    while (n7 < n) {
                        switch (n4 - i) {
                            default: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 23))) {
                                    int n8 = n6 + 2;
                                    byArray[n8] = (byte)(byArray[n8] | 1);
                                }
                            }
                            case 23: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 22))) {
                                    int n9 = n6 + 2;
                                    byArray[n9] = (byte)(byArray[n9] | 2);
                                }
                            }
                            case 22: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 21))) {
                                    int n10 = n6 + 2;
                                    byArray[n10] = (byte)(byArray[n10] | 4);
                                }
                            }
                            case 21: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 20))) {
                                    int n11 = n6 + 2;
                                    byArray[n11] = (byte)(byArray[n11] | 8);
                                }
                            }
                            case 20: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 19))) {
                                    int n12 = n6 + 2;
                                    byArray[n12] = (byte)(byArray[n12] | 0x10);
                                }
                            }
                            case 19: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 18))) {
                                    int n13 = n6 + 2;
                                    byArray[n13] = (byte)(byArray[n13] | 0x20);
                                }
                            }
                            case 18: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 17))) {
                                    int n14 = n6 + 2;
                                    byArray[n14] = (byte)(byArray[n14] | 0x40);
                                }
                            }
                            case 17: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 16))) {
                                    int n15 = n6 + 2;
                                    byArray[n15] = (byte)(byArray[n15] | 0x80);
                                }
                            }
                            case 16: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 15))) {
                                    int n16 = n6 + 1;
                                    byArray[n16] = (byte)(byArray[n16] | 1);
                                }
                            }
                            case 15: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 14))) {
                                    int n17 = n6 + 1;
                                    byArray[n17] = (byte)(byArray[n17] | 2);
                                }
                            }
                            case 14: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 13))) {
                                    int n18 = n6 + 1;
                                    byArray[n18] = (byte)(byArray[n18] | 4);
                                }
                            }
                            case 13: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 12))) {
                                    int n19 = n6 + 1;
                                    byArray[n19] = (byte)(byArray[n19] | 8);
                                }
                            }
                            case 12: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 11))) {
                                    int n20 = n6 + 1;
                                    byArray[n20] = (byte)(byArray[n20] | 0x10);
                                }
                            }
                            case 11: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 10))) {
                                    int n21 = n6 + 1;
                                    byArray[n21] = (byte)(byArray[n21] | 0x20);
                                }
                            }
                            case 10: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 9))) {
                                    int n22 = n6 + 1;
                                    byArray[n22] = (byte)(byArray[n22] | 0x40);
                                }
                            }
                            case 9: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 8))) {
                                    int n23 = n6 + 1;
                                    byArray[n23] = (byte)(byArray[n23] | 0x80);
                                }
                            }
                            case 8: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 7))) {
                                    int n24 = n6;
                                    byArray[n24] = (byte)(byArray[n24] | 1);
                                }
                            }
                            case 7: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 6))) {
                                    int n25 = n6;
                                    byArray[n25] = (byte)(byArray[n25] | 2);
                                }
                            }
                            case 6: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 5))) {
                                    int n26 = n6;
                                    byArray[n26] = (byte)(byArray[n26] | 4);
                                }
                            }
                            case 5: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 4))) {
                                    int n27 = n6;
                                    byArray[n27] = (byte)(byArray[n27] | 8);
                                }
                            }
                            case 4: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 3))) {
                                    int n28 = n6;
                                    byArray[n28] = (byte)(byArray[n28] | 0x10);
                                }
                            }
                            case 3: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, i + 2))) {
                                    int n29 = n6;
                                    byArray[n29] = (byte)(byArray[n29] | 0x20);
                                }
                            }
                            case 2: {
                                if (!this.convertColor2Mono(bufferedImage.getRGB(n7, i + 1))) break;
                                int n30 = n6;
                                byArray[n30] = (byte)(byArray[n30] | 0x40);
                            }
                            case 1: 
                        }
                        if (this.convertColor2Mono(bufferedImage.getRGB(n7, i))) {
                            int n31 = n6;
                            byArray[n31] = (byte)(byArray[n31] | 0x80);
                        }
                        ++n7;
                        n6 += 3;
                    }
                } else if (259 == n3) {
                    n7 = 0;
                    while (n7 < n) {
                        switch (n4 - i) {
                            default: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 24))) {
                                    int n32 = n6;
                                    byArray[n32] = (byte)(byArray[n32] | 0x80);
                                }
                            }
                            case 23: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 23))) {
                                    int n33 = n6;
                                    byArray[n33] = (byte)(byArray[n33] | 0x40);
                                }
                            }
                            case 22: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 22))) {
                                    int n34 = n6;
                                    byArray[n34] = (byte)(byArray[n34] | 0x20);
                                }
                            }
                            case 21: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 21))) {
                                    int n35 = n6;
                                    byArray[n35] = (byte)(byArray[n35] | 0x10);
                                }
                            }
                            case 20: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 20))) {
                                    int n36 = n6;
                                    byArray[n36] = (byte)(byArray[n36] | 8);
                                }
                            }
                            case 19: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 19))) {
                                    int n37 = n6;
                                    byArray[n37] = (byte)(byArray[n37] | 4);
                                }
                            }
                            case 18: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 18))) {
                                    int n38 = n6;
                                    byArray[n38] = (byte)(byArray[n38] | 2);
                                }
                            }
                            case 17: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 17))) {
                                    int n39 = n6;
                                    byArray[n39] = (byte)(byArray[n39] | 1);
                                }
                            }
                            case 16: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 16))) {
                                    int n40 = n6 + 1;
                                    byArray[n40] = (byte)(byArray[n40] | 0x80);
                                }
                            }
                            case 15: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 15))) {
                                    int n41 = n6 + 1;
                                    byArray[n41] = (byte)(byArray[n41] | 0x40);
                                }
                            }
                            case 14: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 14))) {
                                    int n42 = n6 + 1;
                                    byArray[n42] = (byte)(byArray[n42] | 0x20);
                                }
                            }
                            case 13: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 13))) {
                                    int n43 = n6 + 1;
                                    byArray[n43] = (byte)(byArray[n43] | 0x10);
                                }
                            }
                            case 12: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 12))) {
                                    int n44 = n6 + 1;
                                    byArray[n44] = (byte)(byArray[n44] | 8);
                                }
                            }
                            case 11: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 11))) {
                                    int n45 = n6 + 1;
                                    byArray[n45] = (byte)(byArray[n45] | 4);
                                }
                            }
                            case 10: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 10))) {
                                    int n46 = n6 + 1;
                                    byArray[n46] = (byte)(byArray[n46] | 2);
                                }
                            }
                            case 9: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 9))) {
                                    int n47 = n6 + 1;
                                    byArray[n47] = (byte)(byArray[n47] | 1);
                                }
                            }
                            case 8: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 8))) {
                                    int n48 = n6 + 2;
                                    byArray[n48] = (byte)(byArray[n48] | 0x80);
                                }
                            }
                            case 7: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 7))) {
                                    int n49 = n6 + 2;
                                    byArray[n49] = (byte)(byArray[n49] | 0x40);
                                }
                            }
                            case 6: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 6))) {
                                    int n50 = n6 + 2;
                                    byArray[n50] = (byte)(byArray[n50] | 0x20);
                                }
                            }
                            case 5: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 5))) {
                                    int n51 = n6 + 2;
                                    byArray[n51] = (byte)(byArray[n51] | 0x10);
                                }
                            }
                            case 4: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 4))) {
                                    int n52 = n6 + 2;
                                    byArray[n52] = (byte)(byArray[n52] | 8);
                                }
                            }
                            case 3: {
                                if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 3))) {
                                    int n53 = n6 + 2;
                                    byArray[n53] = (byte)(byArray[n53] | 4);
                                }
                            }
                            case 2: {
                                if (!this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 2))) break;
                                int n54 = n6 + 2;
                                byArray[n54] = (byte)(byArray[n54] | 2);
                            }
                            case 1: 
                        }
                        if (this.convertColor2Mono(bufferedImage.getRGB(n7, n4 - i - 1))) {
                            int n55 = n6 + 2;
                            byArray[n55] = (byte)(byArray[n55] | 1);
                        }
                        ++n7;
                        n6 += 3;
                    }
                }
                if (this.m_printerFont.getLineWidthDot() - n2 - n - 1 > 0) {
                    byArray[n6++] = 27;
                    byArray[n6++] = 29;
                    byArray[n6++] = 82;
                    byArray[n6++] = (byte)((this.m_printerFont.getLineWidthDot() - n2 - n - 1) % 256);
                    byArray[n6++] = (byte)((this.m_printerFont.getLineWidthDot() - n2 - n - 1) / 256);
                }
                byArray[n6++] = 27;
                byArray[n6++] = 88;
                byArray[n6++] = 1;
                byArray[n6++] = 0;
                byArray[n6++] = 0;
                byArray[n6++] = 0;
                byArray[n6++] = 0;
                byArray[n6++] = 27;
                byArray[n6++] = 74;
                byArray[n6++] = 12;
            }
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        list.add(byArray);
        return list;
    }
}

